/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.defiledlands;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.gen.RTGChunkGenSettings;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.defiledlands.RealisticBiomeDLBase;
import rtg.world.biome.realistic.defiledlands.SurfaceDLBase;

public class RealisticBiomeDLDesertDefiled
extends RealisticBiomeDLBase {
    public RealisticBiomeDLDesertDefiled(Biome biome) {
        super(biome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaDesert();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaDesert(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B);
    }

    public static class SurfaceVanillaDesert
    extends SurfaceDLBase {
        public SurfaceVanillaDesert(BiomeConfig config, IBlockState top, IBlockState fill) {
            super(config, top, fill);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            boolean water = false;
            boolean riverPaint = false;
            boolean grass = false;
            if (river > 0.05f && river + simplex.noise2f((float)i / 10.0f, (float)j / 10.0f) * 0.1f > 0.86f) {
                riverPaint = true;
                if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > 0.25f) {
                    grass = true;
                }
            }
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (riverPaint) {
                    if (grass && depth < 4) {
                        primer.func_177855_a(x, k, z, this.fillerBlock);
                        continue;
                    }
                    if (depth != 0) continue;
                    primer.func_177855_a(x, k, z, rand.nextInt(2) == 0 ? this.topBlock : this.fillerBlock);
                    continue;
                }
                if (depth > -1 && depth < 5) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 8) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaDesert
    extends TerrainBase {
        public TerrainVanillaDesert() {
            super(64.0f);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            RTGChunkGenSettings settings = rtgWorld.getGeneratorSettings();
            float duneHeight = this.minDuneHeight + (float)settings.sandDuneHeight;
            float stPitch = 200.0f;
            float stFactor = duneHeight *= (1.0f + rtgWorld.simplexInstance(2).noise2f((float)x / 330.0f, (float)y / 330.0f)) / 2.0f;
            float hPitch = 70.0f;
            float hDivisor = 40.0f;
            return TerrainVanillaDesert.terrainPolar(x, y, rtgWorld, river, stPitch, stFactor, hPitch, hDivisor, this.base) + TerrainVanillaDesert.groundNoise(x, y, 1.0f, rtgWorld);
        }
    }
}

